rm(list = ls())
library(yarrr); library(MuMIn)

met.data <- read.csv("trout_metabolism.csv")
boltz <- 0.00008617343   ## The Boltzmann constant
T0 <- 273.15 + 10   ## Approximately the mean temperature of all the streams
met.data$temp.kT <- ((273.15+met.data$temp)-T0)/(boltz*(273.15+met.data$temp)*T0)
met.data$acclimation <- c("cold","warm","warm")[match(met.data$fish,c(12,1,5))]
met.data$acclimation3 <- c("cold","tepid","warm")[match(met.data$fish,c(12,1,5))]
met.data$col <- c("blue","red","red")[match(met.data$fish,c(12,1,5))]
met.data$pch <- c(16,17,17)[match(met.data$fish,c(12,1,5))]
met.data$col3 <- c("blue","orange","red")[match(met.data$fish,c(12,1,5))]
met.data$pch3 <- c(16,17,18)[match(met.data$fish,c(12,1,5))]

## Trout metabolism models including acclimation
m1 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation + temp.kT:acclimation + log(mass):temp.kT:acclimation, data=met.data)
m2 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation + temp.kT:acclimation, data=met.data)
m3 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + log(mass):acclimation, data=met.data)
m4 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT + temp.kT:acclimation, data=met.data)
m5 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation + log(mass):acclimation + temp.kT:acclimation, data=met.data)
m6 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation + log(mass):temp.kT, data=met.data)
m7 <- lm(log(resp) ~ log(mass) + temp.kT + log(mass):temp.kT, data=met.data)
m8 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation + log(mass):acclimation, data=met.data)
m9 <- lm(log(resp) ~ log(mass) + acclimation + log(mass):acclimation, data=met.data)
m10 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation + temp.kT:acclimation, data=met.data)
m11 <- lm(log(resp) ~ temp.kT + acclimation + temp.kT:acclimation, data=met.data)
m12 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation, data=met.data)
m13 <- lm(log(resp) ~ log(mass) + temp.kT, data=met.data)
m14 <- lm(log(resp) ~ log(mass) + acclimation, data=met.data)
m15 <- lm(log(resp) ~ temp.kT + acclimation, data=met.data)
m16 <- lm(log(resp) ~ log(mass), data=met.data)
m17 <- lm(log(resp) ~ temp.kT, data=met.data)
m18 <- lm(log(resp) ~ acclimation, data=met.data)
m19 <- lm(log(resp) ~ 1, data=met.data)
aic <- AICc(m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12,m13,m14,m15,m16,m17,m18,m19)
aic$dAIC <- data.frame(aic[2] - min(aic[2]))$AIC; aic
summary(m13); anova(m13)

met.data$mc_resp <- met.data$resp / met.data$mass^(coef(m13)[2])
summary(mc_mod <- lm(log(mc_resp) ~ temp.kT, data=met.data))
new.mc <- data.frame(temp.kT=seq(min(met.data$temp.kT), max(met.data$temp.kT), length.out=100))
p.mc <- data.frame(predict(mc_mod, newdata=new.mc, interval="confidence"))
met.data$tc_resp <- met.data$resp / exp(met.data$temp.kT*(coef(m13)[3]))
summary(tc_mod <- lm(log(tc_resp) ~ log(mass), data=met.data))
new.tc <- data.frame(mass=seq(min(met.data$mass), max(met.data$mass), length.out=100))
p.tc <- data.frame(predict(tc_mod, newdata=new.tc, interval="confidence"))

write.table(as.matrix(c(capture.output(aic), capture.output(summary(m13)), capture.output(anova(m13)))),
            "Trout metabolism.txt", row.names=F, col.names=F, quote=F)

tiff("Trout metabolism.tif",16,8,pointsize=10,units="cm",res=600,compression="lzw")
par(mar=c(4.5,4.5,1,1), mfrow=c(1,2))
plot(log(mc_resp) ~ temp, pch=pch, col=transparent(col, trans.val=0.3), data=met.data, xlab="", ylab="")
xval <- seq(min(met.data$temp), max(met.data$temp), length.out=100)
polygon(c(xval, rev(xval)), c(p.mc$lwr, rev(p.mc$upr)), col=adjustcolor("black",alpha.f=0.25),  border = NA)
lines(xval, p.mc$fit, lwd=2, lty=1)
mtext(quote(Temperature~("C")), side=1, line=3)
mtext(quote(Ln~metabolic~rate~(mg~O[2]~h^-1~g^-italic(b))), side=2, line=3)
mtext("(a)", side=3, font=2, line=-1.2, adj=0.02)

plot(log(tc_resp) ~ log(mass), pch=pch, col=transparent(col, trans.val=0.3), data=met.data, xlab="", ylab="")
xval <- log(seq(min(met.data$mass), max(met.data$mass), length.out=100))
polygon(c(xval, rev(xval)), c(p.tc$lwr, rev(p.tc$upr)), col=adjustcolor("black",alpha.f=0.25),  border = NA)
lines(xval, p.tc$fit, lwd=2, lty=1)
mtext(quote(Ln~body~mass~(mg)), side=1, line=3)
mtext(quote(Ln~metabolic~rate~(mg~O[2]~h^-1~K^-italic(E))), side=2, line=3)
mtext("(b)", side=3, font=2, line=-1.2, adj=0.02)
legend("bottomright", legend=c("cold (IS12)","warm (IS1+IS5)"), pch=16:17, col=c("blue","red"), lty=1)
dev.off()

## Trout metabolism models including acclimation with three levels
m1 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3 + temp.kT:acclimation3 + log(mass):temp.kT:acclimation3, data=met.data)
m2 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3 + temp.kT:acclimation3, data=met.data)
m3 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + log(mass):acclimation3, data=met.data)
m4 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT + temp.kT:acclimation3, data=met.data)
m5 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3 + log(mass):acclimation3 + temp.kT:acclimation3, data=met.data)
m6 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3 + log(mass):temp.kT, data=met.data)
m7 <- lm(log(resp) ~ log(mass) + temp.kT + log(mass):temp.kT, data=met.data)
m8 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3 + log(mass):acclimation3, data=met.data)
m9 <- lm(log(resp) ~ log(mass) + acclimation3 + log(mass):acclimation3, data=met.data)
m10 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3 + temp.kT:acclimation3, data=met.data)
m11 <- lm(log(resp) ~ temp.kT + acclimation3 + temp.kT:acclimation3, data=met.data)
m12 <- lm(log(resp) ~ log(mass) + temp.kT + acclimation3, data=met.data)
m13 <- lm(log(resp) ~ log(mass) + temp.kT, data=met.data)
m14 <- lm(log(resp) ~ log(mass) + acclimation3, data=met.data)
m15 <- lm(log(resp) ~ temp.kT + acclimation3, data=met.data)
m16 <- lm(log(resp) ~ log(mass), data=met.data)
m17 <- lm(log(resp) ~ temp.kT, data=met.data)
m18 <- lm(log(resp) ~ acclimation3, data=met.data)
m19 <- lm(log(resp) ~ 1, data=met.data)
aic <- AICc(m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12,m13,m14,m15,m16,m17,m18,m19)
aic$dAIC <- data.frame(aic[2] - min(aic[2]))$AIC; aic
summary(m13); anova(m13)

met.data$mc_resp <- met.data$resp / met.data$mass^(coef(m13)[2])
summary(mc_mod <- lm(log(mc_resp) ~ temp.kT, data=met.data))
new.mc <- data.frame(temp.kT=seq(min(met.data$temp.kT), max(met.data$temp.kT), length.out=100))
p.mc <- data.frame(predict(mc_mod, newdata=new.mc, interval="confidence"))
met.data$tc_resp <- met.data$resp / exp(met.data$temp.kT*(coef(m13)[3]))
summary(tc_mod <- lm(log(tc_resp) ~ log(mass), data=met.data))
new.tc <- data.frame(mass=seq(min(met.data$mass), max(met.data$mass), length.out=100))
p.tc <- data.frame(predict(tc_mod, newdata=new.tc, interval="confidence"))
met.data$tc_resp <- met.data$resp / exp(met.data$temp.kT*(coef(m13)[3]))
summary(tc_mod <- lm(log(tc_resp) ~ log(mass), data=met.data))

write.table(as.matrix(c(capture.output(aic), capture.output(summary(m13)), capture.output(anova(m13)))),
            "Trout metabolism (3).txt", row.names=F, col.names=F, quote=F)

tiff("Trout metabolism (3).tif",16,8,pointsize=10,units="cm",res=600,compression="lzw")
par(mar=c(4.5,4.5,1,1), mfrow=c(1,2))
plot(log(mc_resp) ~ temp, pch=pch3, col=transparent(col3, trans.val=0.3), data=met.data, xlab="", ylab="")
xval <- seq(min(met.data$temp), max(met.data$temp), length.out=100)
polygon(c(xval, rev(xval)), c(p.mc$lwr, rev(p.mc$upr)), col=adjustcolor("black",alpha.f=0.25),  border = NA)
lines(xval, p.mc$fit, lwd=2, lty=1)
mtext(quote(Temperature~("C")), side=1, line=3)
mtext(quote(Ln~metabolic~rate~(mg~O[2]~h^-1~g^-italic(b))), side=2, line=3)
mtext("(a)", side=3, font=2, line=-1.2, adj=0.02)

plot(log(tc_resp) ~ log(mass), pch=pch3, col=transparent(col3, trans.val=0.3), data=met.data, xlab="", ylab="")
xval <- log(seq(min(met.data$mass), max(met.data$mass), length.out=100))
polygon(c(xval, rev(xval)), c(p.tc$lwr, rev(p.tc$upr)), col=adjustcolor("black",alpha.f=0.25),  border = NA)
lines(xval, p.tc$fit, lwd=2, lty=1)
mtext(quote(Ln~body~mass~(mg)), side=1, line=3)
mtext(quote(Ln~metabolic~rate~(mg~O[2]~h^-1~K^-italic(E))), side=2, line=3)
mtext("(b)", side=3, font=2, line=-1.2, adj=0.02)
legend("bottomright", legend=c("cold (IS12)","warm (IS1)","warm (IS5)"), pch=16:18, col=c("blue","orange","red"), lty=1)
dev.off()
